jQuery(function ($) {
    var cfg = window.W5EOrder || {};
    var ajaxUrl = cfg.ajax || window.ajaxurl || '';
    var nonce = cfg.nonce || '';
    var i18n = cfg.i18n || {};

    function setStatus(selector, text, isError) {
        var $status = $(selector);
        if (!$status.length) return;
        $status.text(text || '');
        $status.css('color', isError ? '#b32d2e' : '');
    }

    $(document).on('click', '#w5e-send-to-5e-btn', function (e) {
        e.preventDefault();
        var $btn = $(this);
        var orderId = $btn.data('order-id');
        var warehouseId = ($('#w5e-order-warehouse').val() || '').toString();

        if (!warehouseId) {
            setStatus('#w5e-send-to-5e-status', i18n.selectFirst || 'Select a warehouse first.', true);
            return;
        }

        if (!ajaxUrl) {
            setStatus('#w5e-send-to-5e-status', i18n.requestError || 'Request failed.', true);
            return;
        }

        $btn.prop('disabled', true);
        setStatus('#w5e-send-to-5e-status', i18n.sending || 'Sending…', false);

        $.post(ajaxUrl, {
            action: 'w5e_send_order_to_5e',
            nonce: nonce,
            order_id: orderId,
            warehouse_id: warehouseId
        })
            .done(function (resp) {
                if (resp && resp.success) {
                    setStatus('#w5e-send-to-5e-status', (resp.data && resp.data.message) ? resp.data.message : (i18n.sent || 'Sent.'), false);
                } else {
                    var msg = (resp && resp.data && resp.data.message) ? resp.data.message : (i18n.unknownError || 'Unknown');
                    var prefix = i18n.errorPrefix || 'Error:';
                    setStatus('#w5e-send-to-5e-status', prefix + ' ' + msg, true);
                }
            })
            .fail(function () {
                setStatus('#w5e-send-to-5e-status', i18n.requestError || 'Request failed.', true);
            })
            .always(function () {
                $btn.prop('disabled', false);
            });
    });

    $(document).on('click', '#w5e-convert-to-5e-btn', function (e) {
        e.preventDefault();
        var $btn = $(this);
        var orderId = $btn.data('order-id');
        var courierKey = ($('#w5e-order-courier').val() || '').toString();

        if (!courierKey) {
            setStatus('#w5e-convert-to-5e-status', i18n.selectCourierFirst || 'Select a courier first.', true);
            return;
        }

        if (!ajaxUrl) {
            setStatus('#w5e-convert-to-5e-status', i18n.requestError || 'Request failed.', true);
            return;
        }

        $btn.prop('disabled', true);
        setStatus('#w5e-convert-to-5e-status', i18n.converting || 'Switching…', false);

        $.post(ajaxUrl, {
            action: 'w5e_convert_order_to_5e',
            nonce: nonce,
            order_id: orderId,
            courier_key: courierKey
        })
            .done(function (resp) {
                if (resp && resp.success) {
                    setStatus('#w5e-convert-to-5e-status', (resp.data && resp.data.message) ? resp.data.message : (i18n.converted || 'Updated.'), false);
                    window.location.reload();
                } else {
                    var msg = (resp && resp.data && resp.data.message) ? resp.data.message : (i18n.unknownError || 'Unknown');
                    var prefix = i18n.errorPrefix || 'Error:';
                    setStatus('#w5e-convert-to-5e-status', prefix + ' ' + msg, true);
                }
            })
            .fail(function () {
                setStatus('#w5e-convert-to-5e-status', i18n.requestError || 'Request failed.', true);
            })
            .always(function () {
                $btn.prop('disabled', false);
            });
    });
});
