<?php
if (!defined('ABSPATH')) exit;
if (!class_exists('WC_Email')) return;

class W5E_Email_In_Transit extends WC_Email
{
    public $tracking_number;

    public function __construct()
    {
        $this->id          = 'w5e_in_transit';
        $this->title       = __('5E u isporuci', 'woo-5e');
        $this->description = __('Obaveštenje kupcu da je pošiljka predata kuriru (5E).', 'woo-5e');
        $this->heading     = __('Porudžbina je predata kuriru', 'woo-5e');
        $this->subject     = __('Porudžbina #{order_number} je predata kuriru', 'woo-5e');
        $this->template_html  = 'emails/w5e-in-transit.php';
        $this->template_plain = 'emails/plain/w5e-in-transit.php';
        $this->template_base  = W5E_PATH . 'templates/';
        $this->tracking_number = '';

        add_action('w5e_email_in_transit_notification', [$this, 'trigger'], 10, 2);

        parent::__construct();

        $this->customer_email = true;
        $this->recipient      = '';
    }

    public function trigger($order_id, $tracking_number = '')
    {
        if (!$this->is_enabled()) {
            return;
        }

        if ($order_id) {
            $this->object = wc_get_order($order_id);
            if ($this->object) {
                $this->recipient = $this->object->get_billing_email();
            }
        }

        $this->tracking_number = $tracking_number;

        if (!$this->recipient) {
            return;
        }

        $this->placeholders = [
            '{order_date}'   => wc_format_datetime($this->object->get_date_created()),
            '{order_number}' => $this->object->get_order_number(),
        ];

        $this->send($this->get_recipient(), $this->get_subject(), $this->get_content(), $this->get_headers(), $this->get_attachments());
    }

    public function get_content_html()
    {
        return wc_get_template_html(
            $this->template_html,
            [
                'order'           => $this->object,
                'email_heading'   => $this->get_heading(),
                'tracking_number' => $this->tracking_number,
                'sent_to_admin'   => false,
                'plain_text'      => false,
                'email'           => $this,
            ],
            '',
            $this->template_base
        );
    }

    public function get_content_plain()
    {
        return wc_get_template_html(
            $this->template_plain,
            [
                'order'           => $this->object,
                'email_heading'   => $this->get_heading(),
                'tracking_number' => $this->tracking_number,
                'sent_to_admin'   => false,
                'plain_text'      => true,
                'email'           => $this,
            ],
            '',
            $this->template_base
        );
    }

    public function init_form_fields()
    {
        $this->form_fields = [
            'enabled' => [
                'title'   => __('Enable/Disable', 'woo-5e'),
                'type'    => 'checkbox',
                'label'   => __('Enable this email notification', 'woo-5e'),
                'default' => 'yes',
            ],
            'subject' => [
                'title'       => __('Subject', 'woo-5e'),
                'type'        => 'text',
                'description' => __('Leave blank to use the default subject.', 'woo-5e'),
                'placeholder' => '',
                'default'     => '',
            ],
            'heading' => [
                'title'       => __('Email heading', 'woo-5e'),
                'type'        => 'text',
                'description' => __('Leave blank to use the default heading.', 'woo-5e'),
                'placeholder' => '',
                'default'     => '',
            ],
            'email_type' => [
                'title'       => __('Email type', 'woo-5e'),
                'type'        => 'select',
                'description' => __('Choose which format of email to send.', 'woo-5e'),
                'default'     => 'html',
                'class'       => 'email_type',
                'options'     => $this->get_email_type_options(),
            ],
        ];
    }
}
