<?php
if (!defined('ABSPATH')) exit;

/**
 * @var WC_Order $order
 * @var string   $email_heading
 * @var string   $tracking_number
 * @var WC_Email $email
 */

do_action('woocommerce_email_header', $email_heading, $email);
?>
<p><?php printf(esc_html__('Vaša porudžbina #%s je predata kuriru.', 'woo-5e'), esc_html($order->get_order_number())); ?></p>
<?php if (!empty($tracking_number)) : ?>
    <p><?php printf(esc_html__('Broj za praćenje: %s', 'woo-5e'), esc_html($tracking_number)); ?></p>
<?php endif; ?>
<?php do_action('woocommerce_email_order_details', $order, false, false, $email); ?>
<?php do_action('woocommerce_email_order_meta', $order, false, false, $email); ?>
<?php do_action('woocommerce_email_customer_details', $order, false, false, $email); ?>
<?php do_action('woocommerce_email_footer', $email); ?>
